/*
 * File:   Timers.h
 * Author: User
 *
 *
 * В этом файле прописаны функции завязанные на системный таймер SysTick и его инициализация:
 * millis() - Функция возвращает количество микросекунд, прошедших после включения МК или после обнуления регистра-счётчика микросекунд
 * micros() - Функция возвращает количество микросекунд, прошедших с момента включения МК или после обнуления регистра-счётчика
 *            точность около +-5-7  мкС
 * delay() -  Задержка в миллисекундах
 * delayMicroseconds() - Задержка в микросекудах, даёт погрешность
 *
 */

// Блокируем повторное включение этого модуля
#ifndef TIMERS_H
#define TIMERS_H

  //******************************************************************************
  //  Секция include: здесь подключаются заголовочные файлы используемых модулей
  //******************************************************************************
#include <stdint.h>

  //******************************************************************************
  //  Секция определения констант
  //******************************************************************************
  //#define MY_CONST1            1
  //#define MY_CONST2            2
  //#define ...

  //******************************************************************************
  //  Секция определения типов
  //******************************************************************************
  //typedef struct
  //{
  //    ...
  //} T_STRUCT;

  //typedef ...

  //******************************************************************************
  //  Секция определения глобальных переменных
  //******************************************************************************
  //extern char GlobalVar1;
  //extern char GlobalVar2;
  //******************************************************************************
  //  Секция прототипов глобальных функций
  //******************************************************************************
  void SysTickConfig(void);                                                     // Инициализация таймера SysTick и необходимых переменных
  uint32_t millis(void);                                                        // Возращает миллисекунды
  uint32_t micros(void);                                                        // Возвращает микросекунды
  void delay(uint16_t MS);
  void delayMicroseconds(uint16_t US);                                 // Задержка в микросекундах
  //******************************************************************************
  //  Секция определения макросов
  //******************************************************************************
  //#define MACRO1    M1
  //#define MACRO2    M2

// Закрывающий #endif к блокировке повторного включения
#endif  /* MAIN_H */

//******************************************************************************
//  ENF OF FILE
//****************************************************************************** /*
