﻿//****************************************************************************** 
//  Секция include: здесь подключается заголовочный файл к модулю 
//****************************************************************************** 
#include "RCC_48_Init.h"      // Включаем файл заголовка для нашего модуля

//****************************************************************************** 
//  Секция определения переменных, используемых в модуле 
//****************************************************************************** 

//------------------------------------------------------------------------------ 
// Глобальные  
//------------------------------------------------------------------------------ 

//char GlobalVar1; 
//char GlobalVar2; 

//------------------------------------------------------------------------------ 
// Локальные 
//------------------------------------------------------------------------------ 
//****************************************************************************** 
//  Секция прототипов локальных функций 
//****************************************************************************** 

//****************************************************************************** 
//  Секция описания глобальных функций
//****************************************************************************** 

/*
 * Настройка внутреннего генератора на масимальную частоту
 * Запускаемся от внутреннего RC генератора
 */
void SystemClock_Config(uint8_t Quartz)
{
  uint32_t StartUpCounter;
  uint8_t  Mul_PLL;
//  uint32_t HSE_Value;

  RCC->APB1ENR |= RCC_APB1ENR_PWREN;
  RCC->APB2ENR |= RCC_APB2ENR_SYSCFGEN;

  RCC->CFGR2  &= ~RCC_CFGR2_PREDIV_Msk;                                         // На всякий пожарный отключаем предделитель перед PLL

  // Шаг 1. Если кварц есть, запускаем HSE
  if(Quartz)
  {
    RCC->CR      |= RCC_CR_HSEON;                                                 // Запускаем HSE
    for (StartUpCounter = 0;; StartUpCounter++)
    {
      if(RCC->CR & RCC_CR_HSERDY) break;                                          // Запустился, вываливаемся из цикла
      if(StartUpCounter > 0x1000)                                                 // Не запустился гад
      {
        RCC->CR &= ~RCC_CR_HSEON;                                                 //Останавливаем HSE
        return;
      }
    }
  }

  // Шаг 2. Запускаем PLL
  switch (Quartz)
  {
    case Quartz_4:
      Mul_PLL = PLL_MUL_12;
      HSE_Value = 4000000;
      break;
    case Quartz_6:
      Mul_PLL = PLL_MUL_8;
      HSE_Value = 6000000;
      break;
    case Quartz_8:
      Mul_PLL = PLL_MUL_6;
      HSE_Value = 8000000;
      break;
    case Quartz_12:
      Mul_PLL = PLL_MUL_4;
      HSE_Value = 12000000;
      break;
    case Quartz_16:
      Mul_PLL = PLL_MUL_3;
      HSE_Value = 16000000;
      break;
    default:
#if defined(STM32F070x6)
      Mul_PLL = PLL_MUL_6;
#else
      Mul_PLL = PLL_MUL_12;
#endif
      break;
  }

  RCC->CFGR   |= (Mul_PLL << RCC_CFGR_PLLMUL_Pos);                              // Инициализируем умножитель
/*
 * Пересмотреть кусок кода для F030x6
 * В мануале ошибка
 */
  // Следующая операция не подходит для STM32F04x, STM32F07x и STM32F09x
//#if defined(STM32F04x) || defined(STM32F07x) || defined(STM32F09x)
  // Следующая операция не подходит для STM32F04x, STM32F07x и STM32F09x
  // Для них своя, пока не дописана
//#else
//  if(Quartz)
//    RCC->CFGR   |= RCC_CFGR_PLLSRC_HSE_PREDIV;                                  // Если кварц есть, источник тактирования для PLL, является HSE/предделитель
//  else
//    RCC->CFGR   |= RCC_CFGR_PLLSRC_HSI_DIV2;                                    // Если кварца нет, источник тактирования для PLL, является HSI/2
//#endif
/*
 * Код для STM32F070x6, для других смотреть внимательно
 *
 */
#if defined(STM32F070x6)
    if(Quartz)
      RCC->CFGR   |= RCC_CFGR_PLLSRC_HSE_PREDIV;                                // Если кварц есть, источник тактирования для PLL, является HSE/предделитель
    else
      RCC->CFGR   |= RCC_CFGR_PLLSRC_HSI_PREDIV;                                // Если кварца нет, источник тактирования для PLL, является HSI/предделитель
#endif

  RCC->CR     |= RCC_CR_PLLON;                                                  // Включаем PLL
  for (StartUpCounter = 0;; StartUpCounter++)
  {
    if(RCC->CR & RCC_CR_PLLRDY) break;                                          // Запустился, вываливаемся из цикла
    if(StartUpCounter > 0x1000)                                                 // Не запустился гад
    {
      RCC->CR &= ~RCC_CR_PLLON;                                                 //Останавливаем PLL
      return;
    }
  }

  FLASH->ACR  |= (0x02<<FLASH_ACR_LATENCY_Pos);                                 // Таймаут FLASH=2, т.к. частота задающего генератора 48 МГц
  RCC->CFGR   |= (0x02<<RCC_CFGR_SW_Pos);                                       // Переключаемся на работу от PLL
  SysTickConfig();                                                              // Вызываем настройку системного таймера SysTick
}

//****************************************************************************** 
//  Секция описания локальных функций
//****************************************************************************** 
//****************************************************************************** 
//  ENF OF FILE 
//****************************************************************************** 

