/*
 * GPIO.h
 *
 *  Created on: 5 апр. 2021 г.
 *      Author: User
 */

#ifndef GPIO_MAIN_H
#define GPIO_MAIN_H

#include "stdint.h"
#include "STM32.h"

enum TypeOut
{
  Out_Normal,
  Out_Open
};

enum Speed_IO
{
  Speed_Low      = 0b00,
  Speed_Medium   = 0b01,
  Speed_High     = 0b11

};

enum PULL_IO
{
  No_Pull     = 0b00,
  Pull_Up     = 0b01,
  Pull_Down   = 0b10
};

enum IO_Type
{
  Input       = 0b00,
  Output      = 0b01,
  Analog      = 0b11
};

enum IO_Level
{
  Low   = false,
  High  = true
};

void _SetPin(GPIO_TypeDef *GPIOx_Set, uint16_t GPIO_Pin_Set, uint8_t IO_Set, uint8_t PULL_Set);   // Инициализация вывода или группы выводов принадлежащих одному порту
void _SetSpeed(uint8_t Speed_Set);                                                                // Установка скороти порта. Вызывается перед инициализацией
void _SetPull(uint8_t Pull_Set);                                                                  // Зачем то мне понадобилось отключать и включать подтяжку или от отладки осталось.
void _SetTypeOut(uint8_t TypeOutput);
void _SetPinAlternate(GPIO_TypeDef *GPIOx_Set, uint16_t GPIO_Pin_Set, uint8_t Alternate_Set);     // Инициализация альтернативной функции
void _SetDebug_SW(void);                                                                          // Перехват портов ввода/вывода из загребущих ручек дебагера. Пока не реализована.
bool _DigitalReadBit(GPIO_TypeDef *GPIOx_Set, uint16_t GPIO_Pin_Set);
void _DigtalWriteBit(GPIO_TypeDef *GPIOx_Set, uint16_t GPIO_Pin_Set, bool Level);

void _DigitalWrite(GPIO_TypeDef *GPIOx_Set, uint16_t Data);

#endif /* DEVICE_STM32F4XX_INC_GPIO_H_ */
