﻿/*
 * File:   RCC_32_Init.h
 * Author: Анисимов Э.В.
 *
 * Файл содержит функции для инициализации тактового генератора на максимальную частоту 32МГц для МК на базе ядра Cortex-M0
 * Пока он содержит настройку МК STM32L052. По мере надобности, если генератор другого MK серии STM32L0xx будет отличаться,
 * новые МК будут заноситься по мере надобности с помощью условной компиляции.
 *
 */

// Блокируем повторное включение этого модуля 
#ifndef RCC_32_INIT_H
#define	RCC_32_INIT_H

  //****************************************************************************** 
  //  Секция include: здесь подключаются заголовочные файлы используемых модулей 
  //****************************************************************************** 
#include "STM32.h"
//#include "Timers.h"

  //****************************************************************************** 
  //  Секция определения констант 
  //****************************************************************************** 
//enum Quartz
//{
//  Quartz_None = 0,
//  Quartz_4    = 4,
//  Quartz_6    = 6,
//  Quartz_8    = 8,
//  Quartz_12   = 12,
//  Quartz_16   = 16,
//};

// Множитель PLL
#define PLL_MUL_3  0b0000                         // PLL x 3
#define PLL_MUL_4  0b0001                         // PLL x 4
#define PLL_MUL_6  0b0010                         // PLL x 6
#define PLL_MUL_8  0b0011                         // PLL x 8
#define PLL_MUL_12 0b0100                         // PLL x 12
#define PLL_MUL_16 0b0101                         // PLL x 16
#define PLL_MUL_24 0b0110                         // PLL x 24
#define PLL_MUL_32 0b0111                         // PLL x 32
#define PLL_MUL_48 0b1000                         // PLL x 48

// Делитель PLL
#define PLL_DIV_2 0b01                            // PLL/2
#define PLL_DIV_3 0b10                            // PLL/3
#define PLL_DIV_4 0b11                            // PLL/4

//******************************************************************************
  //  Секция определения типов 
  //****************************************************************************** 
  //typedef struct  
  //{ 
  //    ... 
  //} T_STRUCT; 

  //typedef ... 

  //****************************************************************************** 
  //  Секция определения глобальных переменных 
  //****************************************************************************** 
  //extern char GlobalVar1; 
  //extern char GlobalVar2; 
  //****************************************************************************** 
  //  Секция прототипов глобальных функций 
  //****************************************************************************** 
  void SystemClock_Config(void);                                                // Конфигурация тактового генератора и SysTick таймера
  //****************************************************************************** 
  //  Секция определения макросов 
  //****************************************************************************** 
  //#define MACRO1    M1
  //#define MACRO2    M2

// Закрывающий #endif к блокировке повторного включения 
#endif	/* MAIN_H */

//****************************************************************************** 
//  ENF OF FILE 
//****************************************************************************** /* 
