//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************
#include  <stdint.h>
#include "RCC_HSI_72_Init.h"      // Включаем файл заголовка для нашего модуля

//******************************************************************************
//  Секция определения переменных, используемых в модуле
//******************************************************************************

//------------------------------------------------------------------------------
// Глобальные
//------------------------------------------------------------------------------

//char GlobalVar1;
//char GlobalVar2;

//------------------------------------------------------------------------------
// Локальные
//------------------------------------------------------------------------------
//******************************************************************************
//  Секция прототипов локальных функций
//******************************************************************************

//******************************************************************************
//  Секция описания глобальных функций
//******************************************************************************

/*
 * Настройка внутреннего генератора на масимальную частоту.
 * Запуск идёт от внешнего кварцевого резонатора на 8 МГц
 */
void SystemClock_Config(void)
{
  uint32_t StartUpCounter;

  RCC->CR |= RCC_CR_HSEON;                                                      // Запускаем генератор HSE
  for (StartUpCounter = 0;; StartUpCounter++)                                   // В цикле ждём определённое время ожидая запуска
  {
    if(RCC->CR & RCC_CR_HSERDY) break;                                          // Запуск есть, выходим из цикла
    if(StartUpCounter > 0x1000)
    {
      RCC->CR &= ~RCC_CR_HSEON;                                                 // Отключаем HSE
      return;                                                                   // Запуска нет, выходим из функции
    }
  }

  RCC->CFGR   |= RCC_CFGR_PLLMULL_0 | RCC_CFGR_PLLMULL_1 | RCC_CFGR_PLLMULL_2;  // Умножитель PLL=9
  RCC->CR     |= RCC_CR_PLLON;                                                  // Включаем PLL

  for (StartUpCounter = 0;; StartUpCounter++)
  {
    if(RCC->CR & RCC_CR_PLLRDY) break;                                          // Запустился, вываливаемся из цикла
    if(StartUpCounter > 0x1000)                                                 // Не запустился гад
    {
      RCC->CR &= ~RCC_CR_HSEON;                                                 // Отключаем HSE
      RCC->CR &= ~RCC_CR_PLLON;                                                 //Останавливаем PLL
      return;
    }
  }

  FLASH->ACR  |= (0x02<<FLASH_ACR_LATENCY_Pos);                                 // Таймаут FLASH=2, т.к. частота задающего генератора 72 МГц

  //Делители для шин
  RCC->CFGR   |= (0x00<<RCC_CFGR_PPRE2_Pos)                                     //Делитель шины APB2 отключен (оставляем 0 по умолчанию)
              | (0x04<<RCC_CFGR_PPRE1_Pos)                                      //Делитель нишы APB1 равен 2
              | (0x00<<RCC_CFGR_HPRE_Pos);                                      //Делитель AHB отключен (оставляем 0 по умолчанию)

  RCC->CFGR   |= (0x02<<RCC_CFGR_SW_Pos);                                       // Переключаемся на работу от PLL

  while((RCC->CFGR & RCC_CFGR_SWS_Msk) != (0x02<<RCC_CFGR_SWS_Pos))             // Ждём переключения
  {
  }

  SysTickConfig();                                                              // Вызываем настройку системного таймера SysTick
}

//******************************************************************************
//  Секция описания локальных функций
//******************************************************************************
//******************************************************************************
//  ENF OF FILE
//******************************************************************************

