﻿/*
 * File:   RCC_HSI_48.h
 * Author: Анисимов Э.В.
 *
 * Файл содержит функции для инициализации тактового генератора на максимальную частоту 48МГц для МК на базе ядра Cortex-M0
 * Пока он содержит настройку МК STM32F030F4P. По мере надобности, если генератор другого MK серии STM32F0xx будет отличаться,
 * новые МК будут заноситься по мере надобности с помощью условной компиляции.
 *
 */

// Блокируем повторное включение этого модуля 
#ifndef RCC_48_INIT_H
#define	RCC_48_INIT_H

  //****************************************************************************** 
  //  Секция include: здесь подключаются заголовочные файлы используемых модулей 
  //****************************************************************************** 
#include "STM32.h"
#include "Timers.h"

  //****************************************************************************** 
  //  Секция определения констант 
  //****************************************************************************** 
enum Quartz
{
  Quartz_None = 0,
  Quartz_4    = 4,
  Quartz_6    = 6,
  Quartz_8    = 8,
  Quartz_12   = 12,
  Quartz_16   = 16,
};

// Множитель PLL
#define PLL_MUL_2  0b0000                         // PLL x 2
#define PLL_MUL_3  0b0001                         // PLL x 3
#define PLL_MUL_4  0b0010                         // PLL x 4
#define PLL_MUL_5  0b0011                         // PLL x 5
#define PLL_MUL_6  0b0100                         // PLL x 6
#define PLL_MUL_7  0b0101                         // PLL x 7
#define PLL_MUL_8  0b0110                         // PLL x 8
#define PLL_MUL_9  0b0111                         // PLL x 9
#define PLL_MUL_10 0b1000                         // PLL x 10
#define PLL_MUL_11 0b1001                         // PLL x 11
#define PLL_MUL_12 0b1010                         // PLL x 12
#define PLL_MUL_13 0b1011                         // PLL x 13
#define PLL_MUL_14 0b1100                         // PLL x 14
#define PLL_MUL_15 0b1101                         // PLL x 15
#define PLL_MUL_16 0b1110                         // PLL x 16
  //****************************************************************************** 
  //  Секция определения типов 
  //****************************************************************************** 
  //typedef struct  
  //{ 
  //    ... 
  //} T_STRUCT; 

  //typedef ... 

  //****************************************************************************** 
  //  Секция определения глобальных переменных 
  //****************************************************************************** 
  extern uint32_t HSE_Value;
  //****************************************************************************** 
  //  Секция прототипов глобальных функций 
  //****************************************************************************** 
  void SystemClock_Config(uint8_t Quartz);                                                // Конфигурация тактового генератора и SysTick таймера
  //****************************************************************************** 
  //  Секция определения макросов 
  //****************************************************************************** 
  //#define MACRO1    M1
  //#define MACRO2    M2

// Закрывающий #endif к блокировке повторного включения 
#endif	/* MAIN_H */

//****************************************************************************** 
//  ENF OF FILE 
//****************************************************************************** /* 
