/*
 * File:   RCC_HSI_48.h
 * Author: Анисимов Э.В.
 *
 * Файл содержит функции для инициализации тактового генератора на максимальную частоту 48МГц для МК на базе ядра Cortex-M0
 * Пока он содержит настройку МК STM32F030F4P. По мере надобности, если генератор другого MK серии STM32F0xx будет отличаться,
 * новые МК будут заноситься по мере надобности с помощью условной компиляции.
 *
 */

// Блокируем повторное включение этого модуля
#ifndef RCC_HSE_INIT_H
#define RCC_HSE_INIT_H

  //******************************************************************************
  //  Секция include: здесь подключаются заголовочные файлы используемых модулей
  //******************************************************************************
#include <stdint.h>
#include "STM32.h"

  //******************************************************************************
  //  Секция определения констант
  //******************************************************************************
// Делители PLLQ
#define PLLQ_Div_2  0b0010
#define PLLQ_Div_3  0b0011
#define PLLQ_Div_4  0b0100
#define PLLQ_Div_5  0b0101
#define PLLQ_Div_6  0b0110
#define PLLQ_Div_7  0b0111
#define PLLQ_Div_8  0b1000
#define PLLQ_Div_9  0b1001
#define PLLQ_Div_10 0b1010
#define PLLQ_Div_11 0b1011
#define PLLQ_Div_12 0b1100
#define PLLQ_Div_13 0b1101
#define PLLQ_Div_14 0b1110
#define PLLQ_Div_15 0b1111

// Делители PLLP
#define PLLP_Div_2  0b00
#define PLLP_Div_4  0b01
#define PLLP_Div_6  0b10
#define PLLP_Div_8  0b11

// Тактовая частота HSI
//#define HSI_Value 16000000

enum Quartz
{
  Quartz_4  = 4,
  Quartz_6  = 6,
  Quartz_8  = 8,
  Quartz_10 = 10,
  Quartz_12 = 12,
  Quartz_16 = 16,
  Quartz_20 = 20,
  Quartz_25 = 24
};

  //******************************************************************************
  //  Секция определения типов
  //******************************************************************************
  //typedef struct
  //{
  //    ...
  //} T_STRUCT;

  //typedef ...

  //******************************************************************************
  //  Секция определения глобальных переменных
  //******************************************************************************
  extern uint32_t HSE_Value;

  //******************************************************************************
  //  Секция прототипов глобальных функций
  //******************************************************************************
  void SystemClock_Config(uint8_t Quartz);                                      // Конфигурация тактового генератора и SysTick таймера
  //******************************************************************************
  //  Секция определения макросов
  //******************************************************************************
  //#define MACRO1    M1
  //#define MACRO2    M2

// Закрывающий #endif к блокировке повторного включения
#endif  /* MAIN_H */

//******************************************************************************
//  ENF OF FILE
//****************************************************************************** /*
