/*
 * File:   main.h
 * Author: User
 *
 * Created on 18 сентября 2019 г., 13:05
 */

// Блокируем повторное включение этого модуля 
#ifndef _STM32_H
#define	_STM32_H

  //****************************************************************************** 
  //  Секция include: здесь подключаются заголовочные файлы используемых модулей 
  //****************************************************************************** 
  #include <stdint.h>
#if defined(STM32F030x6)
  #include "stm32f030x6.h"
  #include "system_stm32f0xx.h"
  #include "stm32f0xx.h"
#endif

#if defined(STM32F051x8)
  #include "stm32f051x8.h"
  #include "system_stm32f0xx.h"
  #include "stm32f0xx.h"
#endif

#if defined(STM32F070x6)
  #include "stm32f070x6.h"
  #include "system_stm32f0xx.h"
  #include "stm32f0xx.h"
#endif

#include "RCC_48_Init.h"
#include "Timers.h"
#include "IO_Digital.h"
#include "stm32f0xx_gpio.h"
#include "gpio_main.h"


  //****************************************************************************** 
  //  Секция определения констант 
  //****************************************************************************** 
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitToggle(value, bit) ((value) ^= (1UL << (bit)))
#define bitWrite(value, bit, bitvalue) ((bitvalue) ? bitSet(value, bit) : bitClear(value, bit)) 

  //****************************************************************************** 
  //  Секция определения типов 
  //****************************************************************************** 
  //typedef struct  
  //{ 
  //    ... 
  //} T_STRUCT; 

  //typedef ... 

  //****************************************************************************** 
  //  Секция определения глобальных переменных 
  //****************************************************************************** 
  //extern char GlobalVar1; 
  //extern char GlobalVar2; 
  //****************************************************************************** 
  //  Секция прототипов глобальных функций 
  //****************************************************************************** 
  //void global_func1 (void); 
  //void global_func2 (void); 
  //****************************************************************************** 
  //  Секция определения макросов 
  //****************************************************************************** 
  //#define MACRO1    M1
  //#define MACRO2    M2

// Закрывающий #endif к блокировке повторного включения 
#endif	/* MAIN_H */

//****************************************************************************** 
//  ENF OF FILE 
//****************************************************************************** /* 
